/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.LOTRPatron;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNames;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class LOTREntityElf
extends LOTREntityNPC {
    protected EntityAIBase rangedAttackAI = this.createElfRangedAttackAI();
    protected EntityAIBase meleeAttackAI = this.createElfMeleeAttackAI();
    private int soloTick;
    private float soloSpinSpeed;
    private float soloSpin;
    private float prevSoloSpin;
    private float bowAmount;
    private float prevBowAmount;

    public LOTREntityElf(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIEat(this, LOTRFoods.ELF, 12000));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIDrink(this, this.getElfDrinks(), 8000));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.addTargetTasks(true);
    }

    protected LOTRFoods getElfDrinks() {
        return LOTRFoods.ELF_DRINK;
    }

    protected EntityAIBase createElfRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.25, 40, 60, 16.0f);
    }

    protected EntityAIBase createElfMeleeAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.5, false);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(this.field_70146_Z.nextBoolean());
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getSindarinOrQuenyaName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(npcRangedAccuracy).func_111128_a(0.5);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("BoopBoopBaDoop", this.isJazz());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setJazz(nbt.func_74767_n("BoopBoopBaDoop"));
    }

    @Override
    public String getEntityClassName() {
        if (this.isJazz()) {
            return "Jazz-elf";
        }
        return super.getEntityClassName();
    }

    private boolean getJazzFlag(int i) {
        byte b = this.field_70180_af.func_75683_a(22);
        return (b & 1 << i) != 0;
    }

    private void setJazzFlag(int i, boolean flag) {
        byte b = this.field_70180_af.func_75683_a(22);
        int pow2 = 1 << i;
        b = flag ? (byte)(b | pow2) : (byte)(b & ~pow2);
        this.field_70180_af.func_75692_b(22, (Object)b);
    }

    public boolean isJazz() {
        return this.getJazzFlag(0);
    }

    public void setJazz(boolean flag) {
        this.setJazzFlag(0, flag);
    }

    public boolean isSolo() {
        return this.getJazzFlag(1);
    }

    public void setSolo(boolean flag) {
        this.setJazzFlag(1, flag);
    }

    private int getBowingTick() {
        return this.field_70180_af.func_75693_b(23);
    }

    private void setBowingTick(int i) {
        this.field_70180_af.func_75692_b(23, (Object)((short)i));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isJazz()) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.soloTick > 0) {
                    --this.soloTick;
                    this.field_70125_A = -10.0f + (MathHelper.func_76126_a((float)((float)this.soloTick * 0.3f)) + 1.0f) / 2.0f * -30.0f;
                } else if (this.field_70146_Z.nextInt(200) == 0) {
                    this.soloTick = 60 + this.field_70146_Z.nextInt(300);
                }
                this.setSolo(this.soloTick > 0);
            } else if (this.isSolo()) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    double d = this.field_70165_t;
                    double d1 = this.field_70121_D.field_72338_b + (double)this.func_70047_e();
                    double d2 = this.field_70161_v;
                    double d3 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                    double d4 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                    double d5 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                    LOTRMod.proxy.spawnParticle("music", d, d1, d2, d3, d4, d5);
                }
                if (this.soloSpinSpeed == 0.0f || this.field_70146_Z.nextInt(30) == 0) {
                    this.soloSpinSpeed = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)-25.0f, (float)25.0f);
                }
                this.prevSoloSpin = this.soloSpin;
                this.soloSpin += this.soloSpinSpeed;
            } else {
                this.soloSpin = 0.0f;
                this.prevSoloSpin = 0.0f;
                this.soloSpinSpeed = 0.0f;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            double range = 8.0;
            final double rangeSq = range * range;
            EntityPlayer bowingPlayer = null;
            List players = this.field_70170_p.func_82733_a(EntityPlayer.class, this.field_70121_D.func_72314_b(range, range, range), new IEntitySelector(){

                public boolean func_82704_a(Entity entity) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    if (entityplayer.func_70089_S() && LOTREntityElf.this.isFriendly(entityplayer) && LOTREntityElf.this.func_70068_e((Entity)entityplayer) <= rangeSq) {
                        return entityplayer.func_110124_au().equals(LOTRPatron.elfBowPlayer);
                    }
                    return false;
                }
            });
            if (players.isEmpty() || this.func_70638_az() != null) {
                this.setBowingTick(0);
            } else {
                int tick = this.getBowingTick();
                if (tick >= 0) {
                    ++tick;
                }
                if (tick > 40) {
                    tick = -1;
                }
                this.setBowingTick(tick);
                if (tick >= 0) {
                    this.func_70661_as().func_75499_g();
                    bowingPlayer = (EntityPlayer)players.get(0);
                    float bowLook = (float)Math.toDegrees(Math.atan2(bowingPlayer.field_70161_v - this.field_70161_v, bowingPlayer.field_70165_t - this.field_70165_t));
                    this.field_70759_as = bowLook -= 90.0f;
                    this.field_70177_z = bowLook;
                }
            }
        } else {
            this.prevBowAmount = this.bowAmount;
            int tick = this.getBowingTick();
            if (tick <= 0 && this.bowAmount > 0.0f) {
                this.bowAmount -= 0.2f;
                this.bowAmount = Math.max(this.bowAmount, 0.0f);
            } else if (tick > 0 && this.bowAmount < 1.0f) {
                this.bowAmount += 0.2f;
                this.bowAmount = Math.min(this.bowAmount, 1.0f);
            }
        }
    }

    public float getBowingAmount(float f) {
        return this.prevBowAmount + (this.bowAmount - this.prevBowAmount) * f;
    }

    public float getSoloSpin(float f) {
        return this.prevSoloSpin + (this.soloSpin - this.prevSoloSpin) * f;
    }

    public ItemStack func_70694_bm() {
        if (this.field_70170_p.field_72995_K && this.isJazz() && this.isSolo()) {
            return null;
        }
        return super.func_70694_bm();
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        }
        if (mode == LOTREntityNPC.AttackMode.MELEE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
        if (mode == LOTREntityNPC.AttackMode.RANGED) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
            this.func_70062_b(0, this.npcItemsInv.getRangedWeapon());
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(LOTRMod.elfBone, 1);
        }
        this.dropNPCArrows(i);
        this.dropElfItems(flag, i);
    }

    protected void dropElfItems(boolean flag, int i) {
        if (flag) {
            int dropChance = 40 - i * 8;
            if (this.field_70146_Z.nextInt(dropChance = Math.max(dropChance, 1)) == 0) {
                this.func_145779_a(LOTRMod.lembas, 1);
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            return this.liftSpawnRestrictions || this.canElfSpawnHere();
        }
        return false;
    }

    public abstract boolean canElfSpawnHere();

    public void func_70690_d(PotionEffect effect) {
        if (effect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return;
        }
        super.func_70690_d(effect);
    }

    public String func_70639_aQ() {
        if (this.func_70638_az() == null && this.field_70146_Z.nextInt(10) == 0 && this.familyInfo.isMale()) {
            return "lotr:elf.male.say";
        }
        return super.func_70639_aQ();
    }

    @Override
    public String getAttackSound() {
        return this.familyInfo.isMale() ? "lotr:elf.male.attack" : super.getAttackSound();
    }
}

